--- index.cgi.orig	Fri Oct 31 01:05:06 2003
+++ index.cgi	Sun Jan 28 16:45:24 2007
@@ -1,4 +1,4 @@
-#!/usr/pkg/bin/perl
+#!/usr/bin/perl
 
 # Simple Photo Gallery 1.5
 # 
@@ -19,22 +19,48 @@
 # configuration variables
 #########################
 
-my $page_header = ".header.html"; # page header html
-my $page_footer = ".footer.html"; # page footer html
-my $thumbs = ".thumbs"; # thumbnail directory name
-my $lowres = ".lowres"; # low res directory name
+my $page_header = ".header.html";   # page header html
+my $page_footer = ".footer.html";   # page footer html
+my $thumbs = ".thumbs";             # thumbnail directory name
+my $lowres = ".lowres";             # low res directory name
 my $descriptions = ".descriptions"; # descriptions file
-my $startatlast = ".startatlast"; # begin thumbs with the last page
-my $display_filename = 1; # display filename if no description?
-my $page_size = 20; # number of thumbnails per page
-my $number_columns = 5; # how many columns of thumbnails
-my $custom_sort_enable = "YES"; # uses a custom sort algorithm
-$ENV{PATH} .= ':/usr/pkg/bin';
+my $startatlast = ".startatlast";   # begin thumbs with the last page
+my $display_filename = 1;           # display filename if no description?
+my $page_size = 20;                 # number of thumbnails per page
+my $number_columns = 5;             # how many columns of thumbnails
+my $custom_sort_enable = "YES";     # uses a custom sort algorithm
+
+$ENV{PATH} .= ':/usr/local/bin';
+
+############################
+# Message text
+
+my $ImageMsg            = "イメージ";
+my $TakenMsg            = "撮影日";
+my $ExposureMsg         = "露出";
+my $FlashMsg            = "フラッシュ";
+my $FocalLengthMsg      = "焦点距離";
+
+my $H1Msg               = "宴会の写真の一覧";
+my $BackMsg             = "トップーページへ戻る";
+my $PreviewMsg          = " 前へ ";
+my $NextMsg             = " 次へ ";
+my $FullSizeMsg         = "フルサイズ表示";
+my $StartSlideshowMsg   = "スライドショー";
+my $PreviewSizeMsg      = "プレビューサイズ";
+my $PrintableMsg        = "印刷";
+my $BackToThumbnailsMsg = "プレビューの表示";
+
+my $CharSet = "UTF-8";
+
+my $Delay = 5;
+my $ReadMe_File = "README.txt";
 
 ############################
 # end configuration section
 
-my $version = "1.5";
+my $version       = "1.5-jp.4 (日本語ローカライズ化 by TAKANO Yuji)";
+my $MaintainerUrl = "<hr /><small><a href=\"http://www.capybara.org/~dfraser/photo_gallery/\">Simple Photo Gallery</a> $version</small>"; 
 
 # we set a cookie for each gallery to hold the last visited date 
 # and the last page
@@ -47,238 +73,240 @@
 # if d is empty, we're showing the gallery index
 # otherwise, if id is empty, we're viewing thumbnails
 # otherwise, we're viewing a single picture
+
 if (!defined $query->param('d')) {
-	show_gallery_index();
+    show_gallery_index();
+
 } elsif ($query->param('id')) {
-  display_single_image($query);
+    display_single_image($query);
+
 } else {
-  # viewing a page of thumbnails
-  display_thumbnail_page($query);
+
+# viewing a page of thumbnails
+    display_thumbnail_page($query);
 }
 
 exit(0);
 
+############################
+
 sub display_thumbnail_page() {
-  my $dir = $query->param('d');
-  my $safe_dir = uri_escape($dir);
-  cleanDir($dir);
-  my @images = get_images();
-  my $query = shift;
-  my $number_of_pages = int(@images / $page_size)+1;
-	if (@images % $page_size == 0) {
-	  $number_of_pages--;
-	}
-  my $current_page_number = $query->param('pg');
+    my $dir = $query->param('d');
+    my $safe_dir = uri_escape($dir);
+    cleanDir($dir);
+    my @images = get_images();
+    my $query = shift;
+    my $number_of_pages = int(@images / $page_size)+1;
+    if (@images % $page_size == 0) {
+	$number_of_pages--;
+    }
+    my $current_page_number = $query->param('pg');
 
-  if(!defined($current_page_number)) {
-    $current_page_number = 0;
-  }
+    if(!defined($current_page_number)) {
+	$current_page_number = 0;
+    }
   
 
-  print $query->header();
-  display_header();
+    print $query->header(-charset => $CharSet);
+    display_header();
 
-  # allow entry to the last page
-  if($current_page_number eq "last") {
-    $current_page_number = $number_of_pages;
-  }
+# allow entry to the last page
+    if($current_page_number eq "last") {
+	$current_page_number = $number_of_pages;
+    }
 
-  # disallow silly values
-  if ($current_page_number > $number_of_pages-1) {
-    $current_page_number = $number_of_pages - 1;
-  }
-  if ($current_page_number < 0) {
-    $current_page_number = 0;
-  }
-  my $next_page;
-  my $previous_page;
-  my $image_offset = $current_page_number * $page_size;
+# disallow silly values
+    if ($current_page_number > $number_of_pages-1) {
+	$current_page_number = $number_of_pages - 1;
+    }
+    if ($current_page_number < 0) {
+	$current_page_number = 0;
+    }
+    my $next_page;
+    my $previous_page;
+    my $image_offset = $current_page_number * $page_size;
 
-  # figure out the next and previous page numbers
+# figure out the next and previous page numbers
 
-  $next_page = ($current_page_number+1) % $number_of_pages;
-  $previous_page = abs(($current_page_number-1) % $number_of_pages);
+    $next_page = ($current_page_number+1) % $number_of_pages;
+    $previous_page = abs(($current_page_number-1) % $number_of_pages);
 
-  # check if images need to be created
+# check if images need to be created
 #  makeThumbnails($safe_dir);
   
   
-  # print the image tags and links
-  my $current_image = $image_offset;
-  print "<div align=\"center\">";
-  print "<table border=\"0\"><tr>\n";
-  while ($current_image < $image_offset+$page_size and $current_image < @images) {
-   makeThumbnail($dir, $images[$current_image]);
-   print "<td><a href=\"index.cgi?d=$safe_dir&id=$images[$current_image]\"><img src=\"$safe_dir/$thumbs/$images[$current_image]\" border=\"0\"></a></td>\n";
-    print "</tr><tr>\n" if ((($current_image-$image_offset+1) % $number_columns) == 0 and $current_image+1 < $image_offset+$page_size);
-    $current_image++;
-  }
-  print "</tr></table>";
+# print the image tags and links
+    my $current_image = $image_offset;
+    print "<div align=\"center\">";
+    print "<table border=\"0\"><tr>\n";
+    while ($current_image < $image_offset+$page_size and $current_image < @images) {
+	makeThumbnail($dir, $images[$current_image]);
+	print "<td><a href=\"index.cgi?d=$safe_dir&id=$images[$current_image]\"><img src=\"$safe_dir/$thumbs/$images[$current_image]\" border=\"0\"></a></td>\n";
+	print "</tr><tr>\n" if ((($current_image-$image_offset+1) % $number_columns) == 0 and $current_image+1 < $image_offset+$page_size);
+	$current_image++;
+    }
+    print "</tr></table>";
 
-  # print the page navigator
-  print "<br>";
-  print "<table><tr><td>";
-  if ($current_page_number == 0) {
-    print "Previous ";
-  } else {
-    print "<a href=\"index.cgi?d=$safe_dir&pg=$previous_page\">Previous</a> ";
-  }
-  print "</td><td align=\"center\">";
-  for (my $i = 0; $i < $number_of_pages; $i++) {
-    if ($current_page_number == $i) {
-      print "<b>$i</b> ";
+# print the page navigator
+    print "<br>";
+    print "<table><tr><td>";
+    if ($current_page_number == 0) {
+	print "$PreviewMsg ";
     } else {
-      print "<a href=\"index.cgi?d=$safe_dir&pg=$i\">$i</a> ";
+	print "<a href=\"index.cgi?d=$safe_dir&pg=$previous_page\">$PreviewMsg</a> ";
     }
-  }
-  print "</td><td>";
-  if ($current_page_number == $number_of_pages-1) {
-    print "Next";
-  } else {
-    
-    print "<a href=\"index.cgi?d=$safe_dir&pg=$next_page\">Next</a>";
-  }
-  print "</td></tr></table>";
-  print "</div>";
-  print "<p align=\"center\"><a href=\"index.cgi\">Back to Gallery Index</a></p>";
-  display_footer();
+    print "</td><td align=\"center\">";
+
+    for (my $i = 0; $i < $number_of_pages; $i++) {
+	if ($current_page_number == $i) {
+	    print "<b>$i</b> ";
+	} else {
+	    print "<a href=\"index.cgi?d=$safe_dir&pg=$i\">$i</a> ";
+	}
+    }
+
+    print "</td><td>";
+    if ($current_page_number == $number_of_pages-1) {
+	print "$NextMsg";
+    } else {
+    	print "<a href=\"index.cgi?d=$safe_dir&pg=$next_page\">$NextMsg</a>";
+    }
+
+    print "</td></tr></table>";
+    print "</div>";
+    print "<p align=\"center\"><a href=\"index.cgi\">$BackMsg</a></p>";
+    display_footer();
 }
 
 sub display_single_image() {
 
-  # get the current directory
-  my $dir = $query->param('d');
-  my $safe_dir = uri_escape($dir);
-
-    
+# get the current directory
+    my $dir = $query->param('d');
+    my $safe_dir = uri_escape($dir);
    
-  cleanDir($dir);
-  my @images = get_images();
+    cleanDir($dir);
+    my @images = get_images();
   
-
-  # load the description database
-  my %desc;
-  if ( -r "$dir/$descriptions" ) {
-    open DESC, "$dir/$descriptions";
-    my $line;
-    while (defined ($line = <DESC>)) {
-      chomp($line);
-      my ($filename, $description);
-      ($filename, $description) = split(/ /,$line,2);
-      $desc{$filename} = $description;
+# load the description database
+    my %desc;
+    if ( -r "$dir/$descriptions" ) {
+	open DESC, "$dir/$descriptions";
+	my $line;
+
+	while (defined ($line = <DESC>)) {
+	    chomp($line);
+	    my ($filename, $description) = split(/ /,$line,2);
+	    $desc{$filename} = $description;
+	}
     }
-  }
-
 
-  my $image = $query->param('id');
-  my $thumbs_page = $query->param('pg');
-  my $imgnum;
-  for (my $i = 0; $i < @images; $i++) {
-    if ($image eq $images[$i]) {
-      $imgnum = $i;
-      last;
+    my $image = $query->param('id');
+    my $thumbs_page = $query->param('pg');
+    my $imgnum;
+    for (my $i = 0; $i < @images; $i++) {
+	if ($image eq $images[$i]) {
+	    $imgnum = $i;
+	    last;
+	}
     }
-  }
-
-  my $res = $query->param('res');
-my $delay;
-  if ($delay = $query->param('delay')) {
-    print $query->header(-refresh=>"$delay; URL=index.cgi?d=$safe_dir&id=$images[$imgnum+1]&print=1&res=$res&delay=$delay");
-
-  } else {
-    print $query->header;
-  }
-  display_header();
 
+    my $res = $query->param('res');
+    my $delay;
+    if ($delay = $query->param('delay')) {
+	print $query->header(
+	     -charset => $CharSet
+	    ,-refresh => "$delay; URL=index.cgi?d=$safe_dir&id=$images[$imgnum+1]&print=1&res=$res&delay=$delay");
 
-  if (!defined($imgnum)) {
-    print "<p>Image not found! Id is probably invalid.</p>";
-    print "<a href=\"index.cgi?pg=$thumbs_page\">Back to thumbnails</a>";
-    return;
-  }
-  
-  $thumbs_page = int($imgnum / $page_size);  
-  makeLowres($dir,$image);
-  print "<div align=\"center\">";
-  if ($res eq 'high') {
-
-    print "<img src=\"$safe_dir/$image\" border=\"0\"><br />";
-  } else {
-    if ($imgnum+1 < @images) {
-      print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum+1]\">";
-    }
-    print "<img src=\"$safe_dir/$lowres/$image\" border=\"0\"><br />";
-    if ($imgnum+1 < @images) {
-      print "</a>";
+    } else {
+	print $query->header(-charset => $CharSet);
     }
+    display_header();
 
-  }
+    if (!defined($imgnum)) {
+	print "<p>Image not found! Id is probably invalid.</p>";
+	print "<a href=\"index.cgi?pg=$thumbs_page\">$BackToThumbnailsMsg</a>";
+	return;
+    }
+  
+    $thumbs_page = int($imgnum / $page_size);  
+    makeLowres($dir,$image);
+    print "<div align=\"center\">";
 
-  # display the image controls
-  ############################
-  if (!$query->param('print')) {
     if ($res eq 'high') {
-      print "<a href=\"index.cgi?d=$safe_dir&id=$image&pg=$thumbs_page\">Preview Size</a>";
+	print "<img src=\"$safe_dir/$image\" border=\"0\"><br />";
     } else {
-       print "<a href=\"index.cgi?d=$safe_dir&id=$image&res=high&pg=$thumbs_page\">Full Size</a>";
-     }
-    print " * <a href=\"index.cgi?d=$safe_dir&id=$image&res=$res&print=1\" target=\"_blank\">Printable</a>";
-    print " * <a href=\"index.cgi?d=$safe_dir&id=$image&res=$res&print=1&delay=10\">Start Slideshow</a>";
-
-    if ($desc{$images[$imgnum]}) {
-      print "<p align=\"center\"><b>".$desc{$images[$imgnum]}."</b></p>";
-    }
-   
-    # display the navigation
-    ##########################
-      print '<br /><br /><table width="576" cellpadding="0" cellspacing="0" border="0"><tr>';
-      print "<td width=\"33%\" valign=\"top\">";
-      if ($imgnum-1 >= 0) {
-	  makeThumbnail($dir,$images[$imgnum-1]);
-	  print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum-1]\"><img src=\"$safe_dir/$thumbs/$images[$imgnum-1]\"></a><br />Previous";
-      }
-      print "</td>";
-      print "<td align=\"center\">&nbsp;Image #$imgnum of ". ( @images-1) ."&nbsp;<br />";
+	if ($imgnum+1 < @images) {
+	    print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum+1]\">";
+	}
+	print "<img src=\"$safe_dir/$lowres/$image\" border=\"0\"><br />";
+	if ($imgnum+1 < @images) {
+	    print "</a>";
+	}
   }
-    my $info = image_info("$dir/$images[$imgnum]");
-  if (!defined $info->{error}) {
-    print "<small>";
-    print "Taken ".$info->{DateTime}."<br />";
-    print "Exposure: ".$info->{ExposureTime};
-    print " F".eval($info->{FNumber})."<br />";
-    print "  Flash: ".$info->{Flash}."<br />";
-    print " Focal Length: ".eval($info->{FocalLength})."mm<br />";
-    print " ".$info->{Model};
-    print "</small>";
-   }  
-  if (!$query->param('print')) {
-      print "</td>";
-      print "<td width=\"33%\" align=\"right\" valign=\"top\">";
-      if ($imgnum+1 < @images) {
-	  makeThumbnail($dir,$images[$imgnum+1]);
-	  print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum+1]\"><img src=\"$safe_dir/$thumbs/$images[$imgnum+1]\"></a><br />Next" 
-       }
-    print "</td>";
-    
-    print "</tr></table>";
 
+# display the image controls
+############################
+    if (!$query->param('print')) {
+	if ($res eq 'high') {
+	    print "<a href=\"index.cgi?d=$safe_dir&id=$image&pg=$thumbs_page\">$PreviewSizeMsg</a>";
+	} else {
+	    print "<a href=\"index.cgi?d=$safe_dir&id=$image&res=high&pg=$thumbs_page\">$FullSizeMsg</a>";
+	}
+	print " * <a href=\"index.cgi?d=$safe_dir&id=$image&res=$res&print=1\" target=\"_blank\">$PrintableMsg</a>";
+	print " * <a href=\"index.cgi?d=$safe_dir&id=$image&res=$res&print=1&delay=${Delay}\">$StartSlideshowMsg</a>";
 
-  
+	if ($desc{$images[$imgnum]}) {
+	    print "<p align=\"center\"><b>".$desc{$images[$imgnum]}."</b></p>";
+	}
+   
+# display the navigation
+##########################
+	print '<br /><br /><table width="576" cellpadding="0" cellspacing="0" border="0"><tr>';
+	print "<td width=\"33%\" valign=\"top\">";
+	if ($imgnum-1 >= 0) {
+	    makeThumbnail($dir,$images[$imgnum-1]);
+#	    print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum-1]\"><img src=\"$safe_dir/$thumbs/$images[$imgnum-1]\"></a><br />$PreviewMsg";
+	    print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum-1]\"><img src=\"$safe_dir/$thumbs/$images[$imgnum-1]\"></a><br />$PreviewMsg";
+	}
+	print "</td>";
+	print "<td align=\"center\">&nbsp;$ImageMsg #$imgnum of ". ( @images-1) ."&nbsp;<br />";
+    }
 
-    print "<a href=\"index.cgi?d=$safe_dir&pg=$thumbs_page\">Back to thumbnails</a>";
-  }
+    my $info = image_info("$dir/$images[$imgnum]");
+    if (!defined $info->{error}) {
+	print "<small>";
+	print $TakenMsg . " : " .$info->{DateTime}."<br />";
+	print $ExposureMsg . " : " .$info->{ExposureTime};
+	print " F".eval($info->{FNumber})."<br />";
+	print $FlashMsg . " : " .$info->{Flash}."<br />";
+	print $FocalLengthMsg . " : ".eval($info->{FocalLength})."mm<br />";
+	print " ".$info->{Model};
+	print "</small>";
+    }  
+    if (!$query->param('print')) {
+	print "</td>";
+	print "<td width=\"33%\" align=\"right\" valign=\"top\">";
+	if ($imgnum+1 < @images) {
+	    makeThumbnail($dir,$images[$imgnum+1]);
+	    print "<a href=\"index.cgi?d=$safe_dir&id=$images[$imgnum+1]\"><img src=\"$safe_dir/$thumbs/$images[$imgnum+1]\"></a><br />$NextMsg" 
+	}
+	print "</td>";
+	print "</tr></table>";
+	print "<a href=\"index.cgi?d=$safe_dir&pg=$thumbs_page\">$BackToThumbnailsMsg</a>";
+    }
 
-  print "</div>";
-  display_footer();
+    print "</div>";
+    display_footer();
 }
 
 sub display_header() {
-  open HEADER, "$page_header" or die "couldn't open header html file: $!\n";
-  my $line;
-  while (defined ($line = <HEADER>)) {
-    print $line;
-  }
-  close HEADER;
+
+    open HEADER, "$page_header" or die "couldn't open header html file: $!\n";
+    my $line;
+    while (defined ($line = <HEADER>)) {
+	print $line;
+    }
+    close HEADER;
 }
 
 sub show_gallery_index() {
@@ -291,84 +319,100 @@
      }
     my $newCookie = $query->cookie(-name=>'simple_photo_gallery',
 				   -value=>int($lastvisit)." ".int($oldafter));
-    print $query->header(-cookie=>$newCookie);
+    print $query->header(
+	-charset => $CharSet
+	-cookie  => $newCookie
+    );
+#    print "Set-Cookie: $newCookie\n";
+
     display_header();
-    print CGI::h1("Available Galleries");
+    print CGI::h1("$H1Msg");
     my $dirs = find_dirs();
     print "<table>";
     my $dir;
     my @sortedDirs = sort {uc($a) cmp uc($b)} @$dirs;
+
     foreach $dir ( @sortedDirs ) {
-		my $safe_dir = uri_escape($dir);
-		opendir GALLERY, $dir;
-		my @images = grep { /\.[jJ][pP][eE]?[gG]$/ } readdir(GALLERY);
-		close GALLERY;
-		my ($last_modified_time, $total_dir_size);
-		my $image;
-		my $new = 0;
-		foreach $image (@images) {
-		  if ( -r "$dir/$image" ) {
-		    my ($size, $mtime);
-		    ($size, $mtime) = (stat("$dir/$image"))[7,9];
-		    if ($mtime > $last_modified_time) {
-		      $last_modified_time = $mtime;
-		    }
-		    if ($last_modified_time > $lastvisit) { 
-		     	$new++;
-   	        }
-		    $total_dir_size += $size;
-		  }
+	my $safe_dir = uri_escape($dir);
+	opendir GALLERY, $dir;
+	my @images = grep { /\.[jJ][pP][eE]?[gG]$/ } readdir(GALLERY);
+	close GALLERY;
+	my ($last_modified_time, $total_dir_size);
+	my $image;
+	my $new = 0;
+	foreach $image (@images) {
+	    if ( -r "$dir/$image" ) {
+		my ($size, $mtime);
+		($size, $mtime) = (stat("$dir/$image"))[7,9];
+		if ($mtime > $last_modified_time) {
+		    $last_modified_time = $mtime;
 		}
-		if (@images > 0) {
-		  if(-f "$safe_dir/$startatlast") {
-		    print "<tr><td><a href=\"index.cgi?d=${safe_dir}&pg=last\">$dir</a></td>";
-		  }
-		  else {
-		    print "<tr><td><a href=\"index.cgi?d=${safe_dir}\">$dir</a></td>";
-		  }
-
-		  print "<td>".localtime($last_modified_time)."</td>";
-		  my $total_megs = sprintf("%2.1f",($total_dir_size / 1048576));
-		  print "<td>".@images." photos, ${total_megs}MB";
-		  print " <b>($new new)</b>" if ($new);
-		  print "</td></tr>";
-		}
-	      }
-  print "</table>";
-  print "<hr /><small><a href=\"http://www.capybara.org/~dfraser/photo_gallery/\">Simple Photo Gallery</a> $version</small>";
+		if ($last_modified_time > $lastvisit) { 
+		    $new++;
+   	        }
+		$total_dir_size += $size;
+	    }
+	}
+	if (@images > 0) {
+	    if(-f "$safe_dir/$startatlast") {
+		print "<tr><td><a href=\"index.cgi?d=${safe_dir}&pg=last\">$dir</a></td>";
+	    }
+	    else {
+		print "<tr><td><a href=\"index.cgi?d=${safe_dir}\">$dir</a></td>";
+	    }
+
+            my $Msg = "";
+            my $ReadMe = $dir . "/" . $ReadMe_File;
+	    if (-f $ReadMe) {
+                open(MSG,"<$ReadMe");
+                $Msg = <MSG>;
+                close(MSG);
+                print "<td>". $Msg. "</td>";
+	    } else {
+		print "<td>".localtime($last_modified_time)."</td>";
+	    }
+	    my $total_megs = sprintf("%2.1f",($total_dir_size / 1048576));
+	    print "<td>".@images." photos, ${total_megs}MB";
+	    print " <b>($new new)</b>" if ($new);
+	    print "</td></tr>";
+	}
+    }
+    print "</table>";
+    print $MaintainerUrl;
+    print "<hr>";
 }
 
-
 sub find_dirs() {
-	opendir DIR, ".";
-	my @files = readdir DIR;
-	close DIR;
-	my @dirs = grep { $_ ne '.' and $_ ne '..' and -d $_ } @files;
-	return \@dirs;
+    opendir DIR, ".";
+    my @files = readdir DIR;
+    close DIR;
+    my @dirs = grep { $_ ne '.' and $_ ne '..' and -d $_ } @files;
+    return \@dirs;
 }
 
 sub display_footer() {
-  open FOOTER, "$page_footer" or die "couldn't open footer html file: $!\n";
-  my $line;
-  while (defined ($line = <FOOTER>)) {
-    print $line;
-  }
-  close FOOTER;
+    open FOOTER, "$page_footer" or die "couldn't open footer html file: $!\n";
+    my $line;
+    while (defined ($line = <FOOTER>)) {
+	print $line;
+    }
+    close FOOTER;
 }
 
 sub get_images(){
-  # get the current directory
-  my $dir = $query->param('d');
-  opendir DIR,"$dir" or die "couldn't open directory for reading: $!\n";
-  my @images = grep { /^[^.]+\.[jJ][pP][eE]?[gG]$/ } readdir(DIR);
-  if($custom_sort_enable eq "YES"){
-    @images = sort { lc($a) cmp lc($b) } @images;
-  }
-  else{
-    @images = sort @images;
-  }
-  closedir DIR;
-  return @images;
+
+# get the current directory
+    my $dir = $query->param('d');
+    opendir DIR,"$dir" or die "couldn't open directory for reading: $!\n";
+    my @images = grep { /^[^.]+\.[jJ][pP][eE]?[gG]$/ } readdir(DIR);
+    if($custom_sort_enable eq "YES"){
+	@images = sort { lc($a) cmp lc($b) } @images;
+    }
+    else{
+	@images = sort @images;
+    }
+    closedir DIR;
+    return @images;
 }
 
 sub makeThumbnail($$) {
@@ -406,66 +450,69 @@
 }
 
 sub doRotate($) {
-my $dir = shift;
-if ( -f "$dir/.rotation" ) {
-  my $rotate;
+
+    my $dir = shift;
+
+    if ( -f "$dir/.rotation" ) {
+	my $rotate;
+
 #  print "doing rotations based on $dir/.rotation\n";
-  open ROTATE, "$dir/.rotation";
-  while (defined ($rotate = <ROTATE>)) {
-	chomp $rotate;
-	my ($file,$degrees) = split(/ /,$rotate);
-	if (! -f "$dir/$thumbs/${file}.orig" ) {
-	  #print "rotating thumbnail $dir/$file $degrees degrees.\n";
-	  rename "$dir/$thumbs/$file", "$dir/$thumbs/${file}.orig";
-	  system("jpegtran -rotate $degrees '$dir/$thumbs/${file}.orig' > '$dir/$thumbs/$file'");
-	}
-	if (! -f "$dir/$lowres/${file}.orig" ) {
-	  #print "rotating lowres $dir/$file $degrees degrees.\n";
-	  rename "$dir/$lowres/$file", "$dir/$lowres/${file}.orig";
-	  system("jpegtran -rotate $degrees '$dir/$lowres/${file}.orig' > '$dir/$lowres/$file'");
+	open ROTATE, "$dir/.rotation";
+
+	while (defined ($rotate = <ROTATE>)) {
+	    chomp $rotate;
+	    my ($file,$degrees) = split(/ /,$rotate);
+	    if (! -f "$dir/$thumbs/${file}.orig" ) {
+		#print "rotating thumbnail $dir/$file $degrees degrees.\n";
+		rename "$dir/$thumbs/$file", "$dir/$thumbs/${file}.orig";
+		system("jpegtran -rotate $degrees '$dir/$thumbs/${file}.orig' > '$dir/$thumbs/$file'");
+	    }
+	    if (! -f "$dir/$lowres/${file}.orig" ) {
+		#print "rotating lowres $dir/$file $degrees degrees.\n";
+		rename "$dir/$lowres/$file", "$dir/$lowres/${file}.orig";
+		system("jpegtran -rotate $degrees '$dir/$lowres/${file}.orig' > '$dir/$lowres/$file'");
+	    }
 	}
-  }
-}
+    }
 }
 
 sub cleanOrphans($) {
-	my $dir=shift;
-	my $directory;
-	foreach $directory ("$dir/$thumbs", "$dir/$lowres") {
-	# check dir to see if there are stray files
-	#print "removing orphans from $directory directory\n";
+    my $dir=shift;
+    my $directory;
+    foreach $directory ("$dir/$thumbs", "$dir/$lowres") {
+
+# check dir to see if there are stray files
+#	print "removing orphans from $directory directory\n";
 	opendir DIR,"$directory" or die "can't open $directory directory: $!\n";
 	my @files= readdir DIR;
-
-	   closedir DIR;
+	
+	closedir DIR;
 	my $file;
 	foreach $file ( @files ) {
-	# does this file not exist as a hires version
-	if ($file !~ /\.orig$/) {
+# does this file not exist as a hires version
+	    if ($file !~ /\.orig$/) {
 		if(!-r "$dir/$file") {
-	#		print "deleting orphan file: $directory/$file\n";
-			unlink "$directory/$file";
+#		    print "deleting orphan file: $directory/$file\n";
+		    unlink "$directory/$file";
 		}
+	    }
 	}
-
-	
-  }
-  }
+    }
 }
     
 sub makeDirs($) {
-  my $baseDir = shift;
-  my $lowresDir = $baseDir."/".$lowres;
-  my $thumbsDir = $baseDir."/".$thumbs;
-  #print "lowres directory: $lowresDir	thumbs directory: $thumbsDir\n";
+    my $baseDir = shift;
+    my $lowresDir = $baseDir."/".$lowres;
+    my $thumbsDir = $baseDir."/".$thumbs;
+#   print "lowres directory: $lowresDir	thumbs directory: $thumbsDir\n";
   
-  if (! -d $lowresDir) {
+    if (! -d $lowresDir) {
 #	print "creating missing lowres directory: $lowresDir\n";
 	mkdir $lowresDir;
-  }
-  if (! -d $thumbsDir) {
+    }
+    if (! -d $thumbsDir) {
 #	print "creating missing thumbnails directory: $thumbsDir\n";
 	mkdir $thumbsDir;
-  }
+    }
 }
 
